unit fInitControls;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, uEstSearchDialog, uEstSearchDialogAdo, Menus,
  uEstSearchDialogTypes, uEstSearchDialogConst, DB;

type
  TFrmInitControls = class(TForm)
    esdInitControls: TEstSearchDialogAdo;
    btnSearchOrder: TButton;
    mmoComplexSearch: TMemo;
    pumValues: TPopupMenu;
    mniValue1: TMenuItem;
    mniValue2: TMenuItem;
    mniValue3: TMenuItem;
    procedure btnSearchOrderClick(Sender: TObject);
    procedure mniValue1Click(Sender: TObject);
    procedure mniValue2Click(Sender: TObject);
    procedure mniValue3Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure esdInitControlsInitControls(Sender: TObject;
      Field: TEstSearchDialogField; FieldControl: TComboBox;
      Comparison: TSearchComparison; ComparisonControl: TComboBox;
      ValueControl: TEdit; UsingOperator: Boolean;
      OperatorControl: TComboBox);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.dfm}

procedure TFrmInitControls.btnSearchOrderClick(Sender: TObject);
begin
  esdInitControls.Execute;
end;

procedure TFrmInitControls.mniValue1Click(Sender: TObject);
begin
  (pumValues.PopupComponent as TEdit).Text := 'Value1';
end;

procedure TFrmInitControls.mniValue2Click(Sender: TObject);
begin
  (pumValues.PopupComponent as TEdit).Text := 'Value2';
end;

procedure TFrmInitControls.mniValue3Click(Sender: TObject);
begin
  (pumValues.PopupComponent as TEdit).Text := 'Value3';
end;

procedure TFrmInitControls.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TFrmInitControls.esdInitControlsInitControls(Sender: TObject;
  Field: TEstSearchDialogField; FieldControl: TComboBox;
  Comparison: TSearchComparison; ComparisonControl: TComboBox;
  ValueControl: TEdit; UsingOperator: Boolean; OperatorControl: TComboBox);
begin
  // NL: Als het een string veld is, zet dan het popupmenu
  // EN: If the field is a string field, set the popupmenu
  if Field.FieldType in [ftString, ftWideString, ftFixedChar] then
    ValueControl.PopupMenu := pumValues
  else
    ValueControl.PopupMenu := nil;
end;

end.
